#include <GL/gl.h>
#include <GL/glu.h>
#include <stdio.h>
#include <math.h>
#include "openglut.h"
#include "glm.h"
#include "data.h"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

GLMmodel* model;
GLuint list;

int cameraStyle = 0;
float phi = 2;

GLdouble center[] = {0, 0, 0};
GLdouble eye[] = {0, 0, 10};
GLdouble up[] = {0, 10, 0};
GLfloat vzdalenost = 10;


GLfloat t;
GLfloat animationSpeed = 20;  // cas mezi framy v ms


// Konvicka - lestene zlato
static const GLfloat teapot_mat_diffuse[] = { 0.34615, 0.3143, 0.0903, 1.0 };
static const GLfloat teapot_mat_specular[] = { 0.797357, 0.723991, 0.208006, 1.0 };
static const GLfloat teapot_mat_ambient[] = { 0.24725, 0.2245, 0.0645, 1.0 };
static const GLfloat teapot_mat_shinininess[] = { 83.2 };

// Houba - med
static const GLfloat sponge_mat_diffuse[] = {0.7038, 0.27048, 0.0828, 1.0};
static const GLfloat sponge_mat_specular[] = { 0.256777, 0.137622, 0.086014, 1.0 };
static const GLfloat sponge_mat_ambient[] = { 0.19125, 0.0735, 0.0225, 1.0 };
static const GLfloat sponge_mat_shinininess[] = { 12.8 };

// Strelec
static const GLfloat bishop_mat_diffuse[] = { 0.8, 0.8, 0.8, 1.0 };
static const GLfloat bishop_mat_specular[] = { 0.0, 0.0, 0.0, 1.0 };
static const GLfloat bishop_mat_ambient[] = { 0.2, 0.2, 0.2, 1.0 };
static const GLfloat bishop_mat_shinininess[] = { 70 };


struct {
   unsigned char r, g, b;
} Texture[256][256];
GLint Tex;



void getPosOnFergussonsCurve(point3D points[], int count, GLfloat t, point3D *pos) {
   double foo;
   GLfloat F1, F2, F3, F4, p, p_3, p_2;
   
   int i = floor(t);
   i %= count;
   
   p = modf(t, &foo);
   p_3 = p*p*p;
   p_2 = p*p;
   // koeficienty pro vypocet pozice na krivce
   F1 = 2*p_3 - 3*p_2 + 1;
   F2 = -2*p_3 + 3*p_2;
   F3 = p_3 - 2*p_2 + p;
   F4 = p_3 - p_2;

   pos->x = F1*points[i*2].x + F2*points[i*2+2].x + 
            F3*points[i*2+1].x + F4*points[i*2+3].x;
   pos->y = F1*points[i*2].y + F2*points[i*2+2].y + 
            F3*points[i*2+1].y + F4*points[i*2+3].y;
   pos->z = F1*points[i*2].z + F2*points[i*2+2].z + 
            F3*points[i*2+1].z + F4*points[i*2+3].z;
}



void CreateDisplayLists(void) {
   GLdouble offset[3] = {0, 0, 0};
   
   list = glGenLists(3);
   if (list == 0) {
      fprintf(stderr, "Can not create display lists\n");
   }
   
   
   glNewList(list, GL_COMPILE);
   glutSolidSierpinskiSponge (2, offset, 2.5);
   glEndList();
   
   glNewList(list+1, GL_COMPILE);
   glutSolidTeapot(1);
   glEndList();
   
   glNewList(list+2, GL_COMPILE);
   glmDraw(model, GLM_SMOOTH | GLM_TEXTURE);
   glEndList();
}



void onClose(void) {
   glmDelete(model);
}



void onDisplay(void) {
   int i, fl;
   GLfloat fr;
   double foo;
   point3D pos = {0, 0, 0}, rot = {0, 0, 0};
   point3D p;


   glLoadIdentity();
   
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

   // vypocet mista, ktere sleduje kamera
   switch (cameraStyle) {
      case 2 :
               pos.x = cos(M_PI*t)*2;
               pos.y = 0;
               pos.z = sin(M_PI*t)*2;
               break;
      case 3 :
               fr = modf(t, &foo);
               fl = floor(t);
               fl %= 3;
   
               // smerovy vektor aktualni hrany trojuhelniku
               p.x = A[fl == 2 ? 0 : fl+1].x - A[fl].x;
               p.y = A[fl == 2 ? 0 : fl+1].y - A[fl].y;
               p.z = A[fl == 2 ? 0 : fl+1].z - A[fl].z;

               pos.x = A[fl].x + p.x*fr;
               pos.y = A[fl].y + p.y*fr;
               pos.z = A[fl].z + p.z*fr;
               break;
      case 4 :
               getPosOnFergussonsCurve(trajectory, 3, t, &pos);
               getPosOnFergussonsCurve(rotation, 3, t, &rot);
               break;
      default : 
               pos.x = center[0];
               pos.y = center[0];
               pos.z = center[0];
   }
   gluLookAt(eye[0], eye[1], eye[2],
   pos.x, pos.y, pos.z,
   up[0], up[1], up[2]);


   // Vykresleni objektu
   for (i = 0; i < 3; i++) {
      glPushMatrix();
      switch (i) {
         case 0 : // Sierpinskeho houba (nebo co to je) na kruznici
                  glDisable(GL_TEXTURE_2D);
                  pos.x = cos(M_PI*t)*2;
                  pos.y = 0;
                  pos.z = sin(M_PI*t)*2;
                  glTranslatef(pos.x, pos.y, pos.z);
                  glRotatef(-180*t, 0, 1, 0);
                  glMaterialfv(GL_FRONT, GL_DIFFUSE, sponge_mat_diffuse);
                  glMaterialfv(GL_FRONT, GL_SPECULAR, sponge_mat_specular);
                  glMaterialfv(GL_FRONT, GL_AMBIENT, sponge_mat_ambient);
                  glMaterialfv(GL_FRONT, GL_SHININESS, sponge_mat_shinininess);
                  break;
                  
         case 1 : // konvicka na trojuhelniku def. body A[0] .. A[2] (data.h)
                  fr = modf(t, &foo);
                  fl = floor(t);
                  fl %= 3;
                  
                  // smerovy vektor aktualni hrany trojuhelniku
                  p.x = A[fl == 2 ? 0 : fl+1].x - A[fl].x;
                  p.y = A[fl == 2 ? 0 : fl+1].y - A[fl].y;
                  p.z = A[fl == 2 ? 0 : fl+1].z - A[fl].z;

                  pos.x = A[fl].x + p.x*fr;
                  pos.y = A[fl].y + p.y*fr;
                  pos.z = A[fl].z + p.z*fr;

                  glTranslatef(pos.x, pos.y, pos.z);
                  
                  // otoceni roviny podstavy konvicky "do vektoru p"
                  glRotatef(asin(p.y/sqrt(p.x*p.x + p.y*p.y + p.z*p.z)) * (180/M_PI),
                              -p.z, 0, p.x);
                  // otoceni hrdla konvicky do smeru (p.x, 0, p.z)
                  glRotatef((acos(p.x/sqrt(p.x*p.x + p.z*p.z)) * (180/M_PI))
                             * (p.z > 0 ? -1 : 1), 0, 1, 0);
                  
                  glMaterialfv(GL_FRONT, GL_DIFFUSE, teapot_mat_diffuse);
                  glMaterialfv(GL_FRONT, GL_SPECULAR, teapot_mat_specular);
                  glMaterialfv(GL_FRONT, GL_AMBIENT, teapot_mat_ambient);
                  glMaterialfv(GL_FRONT, GL_SHININESS, teapot_mat_shinininess);
                  break;
         
         case 2 : // Figurka strelce na fergussonove krivce
                  // definovane body trajectory[0..2] v data.h
                  // Podobne rotace
                  getPosOnFergussonsCurve(trajectory, 3, t, &pos);
                  getPosOnFergussonsCurve(rotation, 3, t, &rot);
                  // trajectory a rotation je def. v data.h

                  glTranslatef(pos.x, pos.y, pos.z);
                  glRotatef(rot.x, 1, 0, 0);
                  glRotatef(rot.y, 0, 1, 0);
                  glRotatef(rot.z, 0, 0, 1);
                  glMaterialfv(GL_FRONT, GL_DIFFUSE, bishop_mat_diffuse);
                  glMaterialfv(GL_FRONT, GL_SPECULAR, bishop_mat_specular);
                  glMaterialfv(GL_FRONT, GL_AMBIENT, bishop_mat_ambient);
                  glMaterialfv(GL_FRONT, GL_SHININESS, bishop_mat_shinininess);
                  glEnable(GL_TEXTURE_2D);
                  break;
      }
      glCallList(list+i);
      glPopMatrix();
   }
   
   glutSwapBuffers();
}



void onTimer(int foo) {
   t += 0.02;
   glutTimerFunc(animationSpeed, onTimer, 0);
   if (cameraStyle == 1) {
      eye[0] = sin(t*phi) * vzdalenost;
      eye[2] = cos(t*phi) * vzdalenost;
   }

   glutPostRedisplay();
}



void onKeyPressed(unsigned char key, int x, int y) {
   if (key == 'v') {
      if (cameraStyle < 4) {
         cameraStyle++;
      } else {
         cameraStyle = 0;
      }
      switch (cameraStyle) {
         case 0 : printf("Kamera je v klidu\n"); break;
         case 1 : printf("Kamera rotuje a sleduje stred\n"); break;
         case 2 : printf("Kamera sleduje houbu\n"); break;
         case 3 : printf("Kamera sleduje konvicku\n"); break;
         case 4 : printf("Kamera sleduje strelce\n"); break;
      }
   }
   
   glutPostRedisplay();
}



void onResize(int w, int h) {
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(60, w/h, 1, 50);
   glViewport(0, 0, w, h);
   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   glutPostRedisplay();
}


int main(int argc, char* argv[]) {
   int win;
   int x, y;
   FILE *f;
   
   glutInitWindowSize(650, 500);
   glutInitWindowPosition( 140, 140 );
   glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE );
   glutInit(&argc, argv);

   win = glutCreateWindow("OpenGL projekt");
   
   glEnable(GL_DEPTH_TEST);
   
   glEnable(GL_LIGHT0);
   glEnable(GL_LIGHTING);

   
   glutCloseFunc(onClose);
   glutDisplayFunc(onDisplay);
   glutReshapeFunc(onResize);
   glutKeyboardFunc(onKeyPressed);
   
   
   model = glmReadOBJ("bishop.obj");
   if (model == NULL) {
      fprintf(stderr, "Can not open file .obj");
      return 1;
   }
   glmUnitize(model);
   glmReverseWinding(model);
   glmFacetNormals(model);
   glmVertexNormals(model, 90.0);
   glmLinearTexture(model);
   
   // Nacteni textury
   f = fopen("m.bmp", "r");
   if (f == NULL) { return 3;}
   fseek(f, 0x36, SEEK_SET);
   for (y = 0; y < 256; y++) {
      for (x = 0; x < 256; x++) {
         Texture[x][y].b = fgetc(f);
         Texture[x][y].g = fgetc(f);
         Texture[x][y].r = fgetc(f);
      }
   }
   fclose(f);

   glGenTextures(1, &Tex);
   glBindTexture(GL_TEXTURE_2D, Tex);
   glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
   glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER, GL_NEAREST_MIPMAP_LINEAR);
   gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGB, 256, 256, GL_RGB, GL_UNSIGNED_BYTE, &Texture);


   CreateDisplayLists();

   glutTimerFunc(animationSpeed, onTimer, 0);
   
   printf("\nPohyb kamery se prepina klavesou 'v'\n\n");
   printf("Kamera je v klidu\n");

   glutMainLoop();


   return 0;
}
